/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: $
   Last Modification:
    $Author: sspies $
    $Modtime: $
    $Revision: 694 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: no
     WinCE        : no
 
   Description:
    Implementation of the TCP Connector configuration functions
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     3         20.07.2015  RM       Added MessageBox if store configuration fails
     2         27.11.09    SS       Review
     1         27.08.09    SS       created 


**************************************************************************************/

/*****************************************************************************/
/*! \file TCPConfig.cpp                                                     
*   Implementation of the TCP Connector configuration functions              */
/*****************************************************************************/

#include "stdafx.h"

#ifdef WIN64
  #include "resource_x64.h"
#else
  #include "resource_x86.h"
#endif

#include "TCPLayer.h"
#include "TCPConfig.h"
#include "netXConnectorErrors.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_TCP netX TCP Connector                        */
/*! \{                                                                       */
/*****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// Constructor
/////////////////////////////////////////////////////////////////////////////
CTCPConfig::CTCPConfig( BOOL fLoadFormRegistry)
:CConnectorConfig( &g_tConnectorUUID, "IP_RANGE")
{


  /* Register config keys for the TCP connector */

  /*                 Key scope    Name of config key            Default                Min    Max   */
  /*                 ----------   ---------------------------   -------                ---   -----  */
  RegisterConfigKey( eLAYER     , NXCON_TCPKEY_CONNECTTIMEOUT , 100                  , 10  , 10000 );
  RegisterConfigKey( eINTERFACE , NXCON_TCPKEY_PORT           , 50111                , 1   , 65535 );
  RegisterConfigKey( eINTERFACE , NXCON_COMMON_RESETTIMEOUT   , 20000                , 100 , 99999 );

  /*                 Key scope   Name of config key             Default        Regular expression                                        */
  /*                 ----------  ---------------------------   ---------       --------------------------------------------------------- */
  RegisterConfigKey( eINTERFACE, NXCON_TCPKEY_IPBEGIN        , "192.168.1.1" , "^\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?$" );
  RegisterConfigKey( eINTERFACE, NXCON_TCPKEY_IPEND          , "0.0.0.0"     , "^\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?$" );

  /* Load Configuration from registry */
  if (fLoadFormRegistry)
  {
    CString csRegistryKey;
    long lRet = NXCON_NO_ERROR;
    if( NXCON_NO_ERROR != (lRet = LoadFromRegistry(csRegistryKey)))
    {
      CString csText;
      csText.Format(_T("Failed to read TCP connector configuration\r<%s>"), csRegistryKey);
      MessageBox( NULL, csText, _T("netXTransport DLL connector error"), MB_ICONEXCLAMATION);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CTCPConfig::~CTCPConfig()
{
}

/////////////////////////////////////////////////////////////////////////////
/// Request connect timeout
///   \return connect timeout in ms
/////////////////////////////////////////////////////////////////////////////
DWORD CTCPConfig::GetConnectTimeout( void)
{
  DWORD         dwRet = 0;
  CONFIGKEY_MAP cmKeyMap;

  if (NXCON_NO_ERROR == LoadLayerConfig( cmKeyMap))
  {
    dwRet = atoi(cmKeyMap.find(NXCON_TCPKEY_CONNECTTIMEOUT)->second);
  }

  return dwRet;
}

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/

